# Prof-TC
# Decembre 2020
# Mouvement rectiligne accéléré
# Tracé de vecteurs vitesse et variation de vitesse

#Importation des bibliothèques
import csv
import numpy as np
import matplotlib.pyplot as plt

# _____________________________________________________________________________

# Lecture des donnees du fichier CSV
i=0
t = np.array([])
x = np.array([])
y = np.array([])

Fichier_Csv = open("Mouvement rectiligne accelere.csv", 'r')
Objet_Reader_Csv=csv.reader(Fichier_Csv,delimiter = ';')
for Ligne in Objet_Reader_Csv:
    if len(Ligne)!=0 and Ligne!=['Temps', 'X', 'Temps','Y']:
        x=np.append(x,float(Ligne[1].replace(",",".")))
        y=np.append(y,float(Ligne[3].replace(",",".")))
        t=np.append(t,float(Ligne[0].replace(",",".")))
N=len(x)
Fichier_Csv.close()

# _____________________________________________________________________________

# Calculs des vecteurs vitesse

# Nombre de points de mesures
N = len(x)

# Initialisation d'un tableau vide pour les vitesses
vx = np.zeros(N)
vy = np.zeros(N)

# Création du tableau des coordonnées des vitesses
for i in range(1, N-1):
    vx[i]=(x[i+1]-x[i-1])/(2*(t[i+1]-t[i-1]))
    vy[i]=(y[i+1]-y[i-1])/(2*(t[i+1]-t[i-1]))

# Initialisation d'un tableau vide pour les variations desvitesses
dvx = np.zeros(N)
dvy = np.zeros(N)

# Calcul des valeurs des vitesses
v = np.sqrt(vx**2+vy**2)

# Création du tableau des coordonnées des variations des vitesses
for i in range(1, N-1):
    dvx[i]=(vx[i+1]-vx[i-1])
    dvy[i]=(vy[i+1]-vy[i-1])

# Calcul des valeurs des variations des vitesses
dv = np.sqrt(dvx**2+dvy**2)

# Initialisation de la figure
fig, ax = plt.subplots()

# Titre du graphique
plt.title("Mouvement rectiligne accéléré")

# Tracé du graphique
plt.plot(x, y, '+')
plt.xlabel("x (m)")
plt.xlim(min(x)-0.1, max(x)+0.1)
plt.ylabel("y (m)")
plt.ylim(min(y)-0.1, max(y)+0.1)

# Tracé des points
for i in range(1,N,2):
    plt.annotate(i, (x[i]+0.0,y[i]+0.01))
    print("Point ", i, "  t=",t[i], "ms", "  x=", round(x[i],4), "m", "  y=", round(y[i],4), "m", "  v=", round(v[i],4), " m/s")

# Tracé des vecteurs vitesse
for i in range(1,N-1,2):
    plt.arrow(x[i], y[i], vx[i]/10, vy[i]/10, head_width=0.005, color='r')

# Tracé des variations des vecteurs vitesse
#for i in range(1,N-1,2):
#    plt.arrow(x[i], y[i], dvx[i]/10, dvy[i]/10, head_width=0.005, color='b')

#Affichage du graphique
plt.show()

#Sauvegarde du graphique
fig.savefig("Mouvement rectiligne accelere")